unit PPSaverDemo_;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, PPSaver, ExtCtrls, ComCtrls;

type
  TfrmDemo = class(TForm)
    btnMp3a: TButton;
    btnMp3b: TButton;
    btnDVEncoder: TButton;
    btnAVIMux: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    rdgUsePPSaver: TRadioGroup;
    rdgSetOfValues: TRadioGroup;
    rdgRegistryRoot: TRadioGroup;
    StatusBar1: TStatusBar;
    Label5: TLabel;
    edtRegistryStorage: TEdit;
    PropertyPageSaver: TPropertyPageSaver;
    procedure btnMp3bClick(Sender: TObject);
    procedure btnMp3aClick(Sender: TObject);
    procedure btnDVEncoderClick(Sender: TObject);
    procedure btnAVIMuxClick(Sender: TObject);
    procedure rdgUsePPSaverClick(Sender: TObject);
    procedure rdgSetOfValuesClick(Sender: TObject);
    procedure edtRegistryStorageChange(Sender: TObject);
    procedure rdgRegistryRootClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PropertyPageSaverPropertiesRestored(Sender: TObject);
    procedure PropertyPageSaverPropertiesSaved(Sender: TObject);
  private
     procedure DoPropertyPages (CLSID: TGUID);
     procedure UseOleCreatePropertyFrame (pUnk: IUnknown);
     procedure UsePropertyPageSaver (pUnk: IUnknown);
  public
  end;

var
  frmDemo: TfrmDemo;

implementation

uses ActiveX, ComObj;

{$R *.DFM}

const
    CLSID_MP3AudioDecoder : TGUID = '{38BE3000-DBF4-11D0-860E-00A024CFEF6D}';
    CLSID_DVVideoEncoder: TGUID = '{13AA3650-BB6F-11D0-AFB9-00AA00B67A42}';
    CLSID_AVIMux: TGUID = '{E2510970-F137-11CE-8B67-00AA00A3F1A6}';


//------------------------------------------------------------------------------
procedure TfrmDemo.FormCreate(Sender: TObject);
//------------------------------------------------------------------------------
begin
   edtRegistryStorage.Text := PropertyPageSaver.RegistryKey;
   rdgRegistryRoot.ItemIndex := Integer (PropertyPageSaver.RegistryRoot);
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.rdgRegistryRootClick(Sender: TObject);
//------------------------------------------------------------------------------
begin
   case rdgRegistryRoot.ItemIndex of
      0: PropertyPageSaver.RegistryRoot := RR_HKEY_CURRENT_USER;
      1: PropertyPageSaver.RegistryRoot := RR_HKEY_LOCAL_MACHINE;
   end;
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.edtRegistryStorageChange(Sender: TObject);
//------------------------------------------------------------------------------
begin
   PropertyPageSaver.RegistryKey := edtRegistryStorage.Text;
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.UseOleCreatePropertyFrame (pUnk: IUnknown);
//------------------------------------------------------------------------------
var
   SpecifyPropertyPages: ISpecifyPropertyPages;
   auuid: TCAGUID;
begin
   if not assigned (pUnk) then Exit;
   if pUnk.QueryInterface(ISpecifyPropertyPages, SpecifyPropertyPages) = S_OK then begin
      if SpecifyPropertyPages.GetPages(auuid) = S_OK then begin
         if auuid.cElems > 0 then begin
            OleCreatePropertyFrame(frmDemo.Handle, 30, 30, nil, 1, @pUnk, auuid.cElems, auuid.pElems, 0, 0, nil);
         end;
         CoTaskMemFree(auuid.pElems);
      end;
      SpecifyPropertyPages := nil;
   end;
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.UsePropertyPageSaver (pUnk: IUnknown);
//------------------------------------------------------------------------------
begin
   if PropertyPageSaver.Activate (pUnk) then begin  // if the dialog has been sucessfully activated
      PropertyPageSaver.RestoreProperties;          // we restore the properties
      if PropertyPageSaver.ShowDialog then begin    // we show the dialog
         PropertyPageSaver.SaveProperties;          // we save the new properties
      end;
      PropertyPageSaver.Deactivate;                 // and finally we deactivate the dialog
   end;
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.DoPropertyPages (CLSID: TGUID);
//------------------------------------------------------------------------------
var
   pUnk: IUnknown;
begin
   if CoCreateInstance (CLSID, nil, CLSCTX_INPROC_SERVER or CLSCTX_LOCAL_SERVER, IUnknown, pUnk) = S_OK then begin
      if rdgUsePPSaver.ItemIndex = 0 then begin // TPropertyPageSaver saves and restore properties
         UsePropertyPageSaver (pUnk);
      end
      else begin
         UseOleCreatePropertyFrame (pUnk);
      end;
      pUnk := nil;
   end;
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.btnDVEncoderClick(Sender: TObject);
//------------------------------------------------------------------------------
begin
   PropertyPageSaver.DialogTitle := 'DV Video encoder properties';
   PropertyPageSaver.RegistrySubKey := 'DV Video encoder 0' + IntToStr (rdgSetOfValues.ItemIndex + 1);
   PropertyPageSaver.SelectPages := '';
   DoPropertyPages (CLSID_DVVideoEncoder);
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.btnAVIMuxClick(Sender: TObject);
//------------------------------------------------------------------------------
begin
   PropertyPageSaver.DialogTitle := 'AVI Mux properties';
   PropertyPageSaver.RegistrySubKey := 'AVI Mux 0' + IntToStr (rdgSetOfValues.ItemIndex + 1);
   PropertyPageSaver.SelectPages := '';
   DoPropertyPages (CLSID_AVIMux);
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.btnMp3aClick(Sender: TObject);
//------------------------------------------------------------------------------
begin
   PropertyPageSaver.DialogTitle := 'MPEG-Layer3 audio decoder properties';
   PropertyPageSaver.RegistrySubKey := '';
   PropertyPageSaver.SelectPages := '3,2,1';
   DoPropertyPages (CLSID_MP3AudioDecoder);
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.btnMp3bClick(Sender: TObject);
//------------------------------------------------------------------------------
begin
   PropertyPageSaver.DialogTitle := 'MPEG-Layer3 audio decoder properties';
   PropertyPageSaver.RegistrySubKey := 'DV Splitter 0' + IntToStr (rdgSetOfValues.ItemIndex + 1);
   PropertyPageSaver.SelectPages := '3';
   DoPropertyPages (CLSID_MP3AudioDecoder);
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.rdgUsePPSaverClick(Sender: TObject);
//------------------------------------------------------------------------------
var
   PPSaverEnabled: Boolean;
begin
   PPSaverEnabled := rdgUsePPSaver.ItemIndex = 0; // other options disabled if TPropertyPageSaver not used
   rdgSetOfValues.Enabled := PPSaverEnabled;
   rdgRegistryRoot.Enabled := PPSaverEnabled;
   edtRegistryStorage.Enabled := PPSaverEnabled;
   StatusBar1.SimpleText := '';
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.rdgSetOfValuesClick(Sender: TObject);
//------------------------------------------------------------------------------
begin
   StatusBar1.SimpleText := 'You can create several sets of values for each interface.';
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.PropertyPageSaverPropertiesRestored(Sender: TObject);
//------------------------------------------------------------------------------
begin
   StatusBar1.SimpleText := 'Properties restored from: ' + PropertyPageSaver.GetFullRegistryPath;
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.PropertyPageSaverPropertiesSaved(Sender: TObject);
//------------------------------------------------------------------------------
begin
   StatusBar1.SimpleText := 'Properties saved at: ' + PropertyPageSaver.GetFullRegistryPath;
end;

end.
